package edu.uky.ai.lp.gui;

import java.awt.BorderLayout;

import javax.swing.JPanel;

import edu.uky.ai.lp.Game;
import edu.uky.ai.lp.Settings;

public class WumpusPanel extends JPanel {

	private static final long serialVersionUID = Settings.VERSION_UID;

	public final GamePanel game;
	public final Console console;
	
	public WumpusPanel(Game game) {
		setLayout(new BorderLayout());
		this.game = new GamePanel(game);
		add(this.game, BorderLayout.CENTER);
		this.console = new Console();
		add(this.console, BorderLayout.EAST);
	}
	
	@Override
	public boolean requestFocusInWindow() {
		return console.requestFocusInWindow();
	}
}
